% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropEmptyImageDimensions.R
\name{dropEmptyImageDimensions}
\alias{dropEmptyImageDimensions}
\alias{drop_empty_dim}
\title{Drop Empty Image Dimensions}
\usage{
dropEmptyImageDimensions(
  img,
  value = 0,
  threshold = 0,
  other.imgs = NULL,
  keep_ind = FALSE,
  reorient = FALSE
)

drop_empty_dim(
  img,
  value = 0,
  threshold = 0,
  other.imgs = NULL,
  keep_ind = FALSE,
  reorient = FALSE
)
}
\arguments{
\item{img}{nifti object}

\item{value}{Value to check against.  If zero, then 
\code{dropEmptyImageDimensions} will drop any dimension that has 
fewer than \code{threshold} zeroes.  May be a vector of values, matched with 
\code{\link{match}}}

\item{threshold}{Drop dimension if fewer than \code{threshold} voxels
are in the slice}

\item{other.imgs}{List of other nifti objects or filenames 
to apply the same dropping as \code{img}.}

\item{keep_ind}{keep indices in output.  Will return list, even if 
\code{other.imgs} not specified}

\item{reorient}{Should image be reoriented if a filename?}
}
\value{
List of output image indices, and other images
if \code{other.imgs} not specified or \code{keep_ind = TRUE}. 
Otherwise object of class \code{nifti}
}
\description{
Drops dimensions of an image that has all irrelevant
values
}
\note{
\code{drop_empty_dim} is a shorthand for \code{dropEmptyImageDimensions}
with all the same arguments.  Also, \code{NA} are set to zero.
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)

dnim = dropEmptyImageDimensions(nim, keep_ind = TRUE)
new_nim = dnim$outimg
names(dnim)
dnim = dropEmptyImageDimensions(nim, keep_ind = TRUE, other.imgs = nim)
dims = rep(10, 4)
arr = array(rnorm(prod(dims)), dim = dims)
nim = oro.nifti::nifti(arr)

testthat::expect_error(
{dnim = dropEmptyImageDimensions(nim, keep_ind = TRUE)}
)
}
\seealso{
\code{\link{getEmptyImageDimensions}}
}
