% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_deprecated_data.R
\name{show_deprecated_data}
\alias{show_deprecated_data}
\title{show deprecated data}
\usage{
show_deprecated_data(
  product = NA,
  table = NA,
  site = NA,
  start_date = NA,
  end_date = NA,
  type = NA,
  ext = NA,
  timestamp = NA,
  release = NA,
  dir = neon_dir()
)
}
\arguments{
\item{product}{A NEON \code{productCode} or list of product codes, see examples.}

\item{table}{Include only files matching this table name (or regex pattern).
(optional).}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{type}{Should we prefer the basic or expanded version of this product?
Note that not all products have expanded formats.}

\item{ext}{only match files with this file extension(s)}

\item{timestamp}{only match timestamps prior this. See details in \code{\link[=neon_index]{neon_index()}}.
Should be a datetime POSIXct object (or coerce-able string)}

\item{release}{Select only data files associated with a particular release tag,
see \url{https://www.neonscience.org/data-samples/data-management/data-revisions-releases},
e.g. "RELEASE-2021".  Releases are associated with a specific DOI and the promise that
files associated with a particular release will not change.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \code{\link[tools:userdir]{tools::R_user_dir()}}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}
}
\description{
Show the file information for any raw data files which have been deprecated by
the release of modified historical data to the NEON API.
}
\details{
NEON data files are sometimes updated to correct errors.  Old files are
removed from access from the API, but may be present in your local store
from an earlier download.  \code{neonstore} stacking functions (\verb{[neon_read()]}
and \code{neon_store()}) automatically exclude these deprecated files, though
\code{neon_read()} can be instructed to use older files by passing a file list.

A data file is identified as deprecated whenever the local file store contains
a second data file with the same product, table, site, month, and position
(sensor products only) information, but having an updated timestamp.  If such
a change occurs in a file with a non-missing "month" code, it may indicate a
data file has been updated.  This could result in changes to the results of
any previous analyses.

Note that metadata files, (readme, variables, positions) are 'pre-stacked':
the metadata file in a given product-site-month set contains metadata going back
to the start and not just for that month.  As a result, each new version deprecates
the old metadata file, but the old files are always available from the NEON API
and always present in the store.  Users will only need to care about the most recent
ones, and the presence of old files is no cause for concern. This function will
only show data files that have changed, and not metadata files.  This can
help pinpoint specific altered data.
}
\examples{
\dontshow{
# Hide setting tempfile, since a user would specify a persistent location
 Sys.setenv("NEONSTORE_HOME"=tempfile())
}
show_deprecated_data()


\dontshow{
# tidy
 Sys.unsetenv("NEONSTORE_HOME")
}

}
\seealso{
neon_index, neon_read
}
