% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scToNeb.R
\name{scToNeb}
\alias{scToNeb}
\title{Retrieve data from Seurat or SingleCellExperiment object to prepare for use in nebula}
\usage{
scToNeb(
  obj,
  assay = NULL,
  id = NULL,
  pred = NULL,
  offset = NULL,
  verbose = TRUE
)
}
\arguments{
\item{obj}{\code{Seurat} or \code{SingleCellExperiment} object to create data set for Nebula.}

\item{assay}{Assay to retrieve counts from the corresponding \code{Seurat} count matrix.}

\item{id}{Sample ID to use metadata object i.e. \code{obj$id}.}

\item{pred}{Character vector of predictors from metadata in \code{Seurat} or \code{SingleCellExperiment} objects.}

\item{offset}{Metadata column corresponding to per-cell scaling factor e.g. TMM.}

\item{verbose}{Indicating whether to print additional messages.}
}
\value{
data_neb: A list usable for nebula.
}
\description{
Retrieve data from Seurat or SingleCellExperiment object to prepare for use in nebula
}
\examples{
\dontrun{
library(Seurat)
library(nebula)

data("sample_seurat")
re <- scToNeb(obj = sample_seurat, assay = "RNA", id = "replicate", pred = c("celltype", "tech"))
}
}
