% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndjson.R
\name{stream_in}
\alias{stream_in}
\title{Stream in & flatten an ndjson file into a \code{tbl_dt}}
\usage{
stream_in(path)
}
\arguments{
\item{path}{path to file (supports "\code{gz}" files)}
}
\value{
\code{tbl_dt}
}
\description{
Given a file of streaming JSON (ndjson) this function reads in the records
and creates a flat \code{data.table} / \code{tbl_dt} from it.
}
\examples{
f <- system.file("extdata", "test.json", package="ndjson")
nrow(stream_in(f))

gzf <- system.file("extdata", "testgz.json.gz", package="ndjson")
nrow(stream_in(gzf))
}
\references{
\url{http://ndjson.org/}
}

