% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa}
\alias{lisa}
\title{Local indicator of spatial association}
\usage{
lisa(x, y, z, neigh, resamp = 1000, latlon = FALSE, quiet = FALSE)
}
\arguments{
\item{x}{vector of length n representing the x coordinates (or latitude; see latlon).}

\item{y}{vector of length n representing the y coordinates (or longitude).}

\item{z}{vector of n representing the observation at each location.}

\item{neigh}{neighborhood size.}

\item{resamp}{number of resamples under the NULL to generate p-values}

\item{latlon}{If TRUE, coordinates are latitude and longitude.}

\item{quiet}{If TRUE, the counter is suppressed during execution.}
}
\value{
An object of class "lisa" is returned, consisting of the following components: 
\item{correlation}{the autocorrelation within the neighborhood (neigh) of each observation measured using Moran's I.}
\item{p}{the permutation two-sided p-value for each observation.}
\item{mean}{the mean of the observations inside each neighborhooddistance within each neighborhood.}
\item{n}{the number of observations within each neighborhood.}
\item{dmean}{the actual mean distance within each neighborhood.}
\item{z}{the original observations}
\item{coord}{a list with the x and y coordinates.}
}
\description{
\code{lisa} is a function to estimate the local indicators of spatial association. The function assumes univariate data at each location. For multivariate data use \code{\link{lisa.nc}}
}
\details{
This is the function to estimate the local indicators of spatial association modified form Anselin (1995). The statistic is the average autocorrelation within a neighborhood.
}
\examples{
# first generate some sample data
x <- expand.grid(1:20, 1:5)[, 1]
y <- expand.grid(1:20, 1:5)[, 2]

# z data from an exponential random field
z <- rmvn.spa(x = x, y = y, p = 2, method = "gaus")

# lisa analysis
fit1 <- lisa(x = x, y = y, z = z, neigh = 3, resamp = 500)
\dontrun{plot(fit1, neigh.mean=FALSE)}
}
\references{
Anselin, L. 1995. Local indicators of spatial association - LISA. Geographical Analysis 27:93-115. \url{https://doi.org/10.1111/j.1538-4632.1995.tb00338.x}
}
\seealso{
\code{\link{plot.lisa}}
}
\author{
Ottar N. Bjornstad \email{onb1@psu.edu}
}
\keyword{spatial}
