% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadows.R
\name{unbinders}
\alias{unbinders}
\alias{unbind_shadow}
\alias{unbind_data}
\title{Unbind (remove) shadow from data, and vice versa}
\usage{
unbind_shadow(data)

unbind_data(data)
}
\arguments{
\item{data}{data.frame containing shadow columns (created by \code{\link[=bind_shadow]{bind_shadow()}})}
}
\value{
\code{data.frame} without shadow columns if using \code{\link[=unbind_shadow]{unbind_shadow()}}, or
without the original data, if using \code{\link[=unbind_data]{unbind_data()}}.
}
\description{
Remove the shadow variables (which end in \verb{_NA}) from the data, or vice versa.
This will also remove the \code{nabular} class from the data.
}
\examples{

# bind shadow columns
aq_sh <- bind_shadow(airquality)

# print data
aq_sh

# remove shadow columns
unbind_shadow(aq_sh)

# remove data
unbind_data(aq_sh)

# errors when you don't use data with shadows
\dontrun{
 unbind_data(airquality)
 unbind_shadow(airquality)
}

}
