% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shade.R
\name{shade}
\alias{shade}
\title{Create new levels of missing}
\usage{
shade(x, ..., extra_levels = NULL)
}
\arguments{
\item{x}{a vector}

\item{...}{additional levels of missing to add}

\item{extra_levels}{is a}
}
\description{
Returns (at least) factors of !NA and NA, where !NA indicates a datum that is
not missing, and NA indicates missingness. It also allows you to specify
some new missings, if you like. This function is what powers the factor
levels in \code{as_shadow()}.
}
\examples{
df <- tibble::tribble(
  ~wind, ~temp,
  -99,    45,
  68,    NA,
  72,    25
  )

shade(df$wind)

shade(df$wind,
      inst_fail = -99)

shade(df$wind,
      inst_fail = 100)

}
