% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-item-interpreting.R
\name{naaccr_boolean}
\alias{naaccr_boolean}
\title{Interpret NAACCR-style booleans}
\usage{
naaccr_boolean(flag, false_value = c("0", "1"))
}
\arguments{
\item{flag}{Character vector of flags.}

\item{false_value}{The flag value to interpret as \code{FALSE}. If \code{"0"}
(default), then \code{"1"} is interpreted as \code{TRUE}. If \code{"1"},
then \code{"2"} is interpreted as \code{TRUE}.}
}
\value{
A \code{logical} vector with the interpreted values of \code{flag}.
  Any original values not seen as \code{TRUE} or \code{FALSE} are converted
  to \code{NA}.
}
\description{
Interpret NAACCR-style booleans
}
\examples{
  x <- c("0", "1", "2", "9", NA)
  naaccr_boolean(x)
  naaccr_boolean(x, false_value = "1")
}
