% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABC_SMC.R
\name{mcmc_nltt}
\alias{mcmc_nltt}
\title{function, using a Monte Carlo Markov Chain}
\usage{
mcmc_nltt(
  phy,
  likelihood_function,
  parameters,
  logtransforms,
  iterations,
  burnin = round(iterations/3),
  thinning = 1,
  sigma = 1
)
}
\arguments{
\item{phy}{phylo       Vector of weights}

\item{likelihood_function}{function    Function that calculates the
likelihood of our diversification
model, given the tree.
function should be of the format
function(parameters, phy).}

\item{parameters}{vector      Initial parameters to start
the chain.}

\item{logtransforms}{scalar      Whether to perform jumps on
logtransformed parameters (TRUE)
or not (FALSE)}

\item{iterations}{scalar      Length of the chain}

\item{burnin}{scalar      Length of the burnin, default is
30\% of iterations}

\item{thinning}{scalar      Size of thinning, default = 1}

\item{sigma}{scalar      Standard deviation of the jumping
distribution, which is
N(0, sigma).}
}
\value{
mcmc        An MCMC object, as used by the
                                            package "coda".
}
\description{
function, using a Monte Carlo Markov Chain
}
