% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_meta_locality}
\alias{mc_prep_meta_locality}
\title{Set metadata of localities}
\usage{
mc_prep_meta_locality(data, values, param_name = NULL)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{values}{for localities can be named list or table
\itemize{
\item named list: \code{metadata <- list(locality_id=value)}; \code{param_name} must be set
\item table with column \code{locality_id} and another columns named by metadata parameter name;
to rename locality use \code{new_locality_id}. Parameter \code{param_name} must be NULL.
}}

\item{param_name}{name of locality metadata parameter; Default names are \code{locality_id}, \code{elevation}, \code{lat_wgs84}, \code{lon_wgs84}, \code{tz_offset}.
Another names are inserted to \code{user_data} list. see \link{mc_LocalityMetadata}}
}
\value{
myClim object in the same format as input, with updated metadata
}
\description{
This function allows you to add or modify locality metadata including
locality names. See \link{mc_LocalityMetadata}.
You can import metadata from named list or from data frame. See details.
}
\details{
Locality metadata is especially useful for handling time zones, considering temporal cycling.
E.g. while providing coordinates, and in case you are sure, the loggers recorded in UTC,
you can harmonize all data to the solar time (midday) with \code{\link[=mc_prep_solar_tz]{mc_prep_solar_tz()}}
calculating offset to the UTC based on coordinates. Or you can directly provide
the offset in minutes yourself for individual localities. This is useful e.g.
for heterogeneous data sets containing loggers recording in local time
and you wish to unify them by setting individual offset e.g. back to UTC.
If tz_offset is set manually, than tz_type is set to \verb{user defined}.

For minor metadata modification it is practical to use named list in combination
with \code{param_name} specification. E.g. when you wish to modify only time zone offset,
then set \code{param_name="tz_offset"} and provide named list with locality name and
offset value \code{list(A1E05=60)}. Similarly for other metadata slots \link{mc_LocalityMetadata}.

For batch or generally more complex metadata modification you can provide data.frame
with columns specifying \code{locality_id} and one of \verb{new_locality_id, elevation, lat_wgs84, lon_wgs84, tz_offset}.
Provide locality_id (name) and the value in column of metadata you wish to update.
In case of using data.frame use \code{param_name = NULL}
}
\examples{
data <- mc_prep_meta_locality(mc_data_example_raw, list(A1E05=60), param_name="tz_offset")
}
