% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_fcm.R
\name{run_fcm}
\alias{run_fcm}
\title{Run Function Cox Models}
\usage{
run_fcm(
  mxFDAobject,
  model_name,
  formula,
  event = "event",
  metric = "uni k",
  r = "r",
  value = "fundiff",
  afcm = FALSE,
  smooth = FALSE,
  filter_cols = NULL,
  ...,
  knots = NULL
)
}
\arguments{
\item{mxFDAobject}{Dataframe of spatial summary functions from multiplex imaging data, in long format. Can be estimated using the function \code{extract_summary_functions} or provided separately.}

\item{model_name}{character string to give the fit model in the functional cox slot}

\item{formula}{Formula to be fed to mgcv in the form of survival_time ~ x1 + x2. Does not contain functional predictor. Character valued. Data must contain censoring variable called "event".}

\item{event}{character string for the column in Metadata that contains 1/0 for the survival event}

\item{metric}{name of calculated spatial metric to use}

\item{r}{Character string, the name of the variable that identifies the function domain (usually a radius for spatial summary functions). Default is "r".}

\item{value}{Character string, the name of the variable that identifies the spatial summary function values. Default is "fundiff".}

\item{afcm}{If TRUE, runs additive functional Cox model. If FALSE, runs linear functional cox model. Defaults to linear functional cox model.}

\item{smooth}{Option to smooth data using FPCA. Defaults to FALSE.}

\item{filter_cols}{a named vector of factors to filter summary functions to in \code{c(Derived_Column = "Level_to_Filter")} format}

\item{...}{Optional other arguments to be passed to \code{fpca.face}}

\item{knots}{Number of knots for defining spline basis.}
}
\value{
A \code{list} which is a linear or additive functional Cox model fit. See \code{mgcv::gam} for more details.
}
\description{
Fit a functional Cox regression model.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load ovarian mxFDA object
data('ovarian_FDA')

#run the lfcm model
ovarian_FDA = run_fcm(ovarian_FDA, model_name = "fit_lfcm",
                      formula = survival_time ~ age, event = "event",
                      metric = "uni g", r = "r", value = "fundiff",
                      afcm = FALSE)

}
\author{
Julia Wrobel \email{julia.wrobel@emory.edu}

Alex Soupir \email{alex.soupir@moffitt.org}
}
