% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sigmaSNR}
\alias{sigmaSNR}
\title{Determine noise scale levels from specified \bold{S}ignal to \bold{N}oise \bold{R}atios}
\usage{
sigmaSNR(signal, SNR)
}
\arguments{
\item{signal}{Noisefree multichannel input signal}

\item{SNR}{A numeric vector specifying the desired \bold{S}ignal to \bold{N}oise \bold{R}atio for each channel.}
}
\value{
A numeric vector with m elements giving the scales (standard deviation of the noise in each channel) to achieve the desired SNR.
}
\description{
Determine noise scale levels from specified \bold{S}ignal to \bold{N}oise \bold{R}atios
}
\details{
The output noise scale levels (theoretical standard deviation for the process noise process in each channel) is governed by the blurred \bold{S}ignal-to-\bold{N}oise \bold{R}atio (SNR) measured in decibels (dB) where,
\deqn{SNR  = 10 log_{10} (\frac{||k*f||^2}{\sigma^2)}}
and k*f is the blurred signal, \eqn{||\cdot||} is the norm operator and \eqn{\sigma} is the standard deviation of the noise. Roughly speaking, noise levels are considered high, medium and low for the cases 10 dB, 20 dB and 30 dB respectively.
}
\examples{
n <- 1024
m <- 3
signal <- makeLIDAR(n)
blur <- gammaBlur(n, c(0.5, 0.75, 1), rep(1, m))
X <- blurSignal(signal, blur)
SNR <- 10*1:3
sigma <- sigmaSNR(X, SNR)
E <- multiNoise(n, sigma)
sigmaEst <- multiSigma(E)
}
\seealso{
\code{\link{multiNoise}} \code{\link{multiSigma}}
}

