% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvt.R
\name{rmvt}
\alias{rmvt}
\title{Multivariate t Distribution Random Variates}
\usage{
rmvt(n, df = 30, Q = NULL, delta = rep(0, d))
}
\arguments{
\item{n}{number of observations}

\item{df}{default to 30.}

\item{Q}{semi-positive definite}

\item{delta}{location vector.}
}
\value{
A \code{n} by \code{d} matrix containing multivariate t random variates
where \code{d=nrow(Q)}.
}
\description{
Computes random vectors of the multivariate t distribution
distribution for arbitrary correlation matrices using gamma variates
not chi/sqrt(nu).
}
\examples{
## sample usage
rmvt(10, df=4, Q=diag(5))

## compare to rmvt from mvtnorm R-package
draw_mvtnorm <- mvtnorm::rmvt(2e4, sigma=diag(2), df = 35)
draw_mvgb    <-    mvgb::rmvt(2e4,     Q=diag(2), df = 35)

rangex <- range(c(draw_mvgb[,1],draw_mvtnorm[,1]))
rangey <- range(c(draw_mvgb[,2],draw_mvtnorm[,2]))

## https://stackoverflow.com/a/53804499/2727349
opar <- par(mfrow=c(2,2))
plot(draw_mvtnorm, xlim=rangex, ylim=rangey); abline(h=0,v=0)
plot(draw_mvgb   , xlim=rangex, ylim=rangey); abline(h=0,v=0)

hist(draw_mvtnorm, breaks = 100, ylim=c(0,4000), xlim=rangex)
hist(draw_mvgb   , breaks = 100, ylim=c(0,4000), xlim=rangex)
par(opar)

}
\references{
Genz, A. and Bretz, F. (2002), Methods for the computation of multivariate
t-probabilities. \emph{Journal of Computational and Graphical Statistics},
\bold{11}, 950--971.
}
\keyword{distribution}
