% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statepathways.R
\name{plot_predicted_pathway}
\alias{plot_predicted_pathway}
\title{Displays the predicted flow for a given individual through the system}
\usage{
plot_predicted_pathway(
  models,
  trans_mat,
  newdata,
  times,
  starting_state = 1,
  tcovs = NULL
)
}
\arguments{
\item{models}{List of \code{flexsurvreg} objects.}

\item{trans_mat}{Transition matrix, such as that used in \code{mstate}.}

\item{newdata}{A data frame containing the attributes of the person
to display the predicted state flow for. As the diagram can only
be displayed for a single individual it will ignore any rows
after the first.}

\item{times}{The time-points at which to estimate transition
probabilities.}

\item{starting_state}{Starting state. Either number or character name in \code{trans_mat}.}

\item{tcovs}{As in \code{flexsurv::pmatrix.simfs}, this is the names of covariates that need to be
incremented by the simulation clock at each transition, such as age when modelled as age at state entry.}
}
\value{
The HTML widget.
}
\description{
Produces an interactive HTML widget that displays a Sankey diagram showing a
predicted patient pathway through the multi-state model.
}
\examples{

library(multistateutils)
library(mstate)
library(flexsurv)

# Convert data to long
data(ebmt3)
tmat <- trans.illdeath()
long <- msprep(time=c(NA, 'prtime', 'rfstime'), 
               status=c(NA, 'prstat', 'rfsstat'), 
               data=ebmt3, 
               trans=tmat, 
               keep=c('age', 'dissub'))
               
# Fit parametric models
models <- lapply(1:3, function(i) {
    flexsurvreg(Surv(time, status) ~ age + dissub, data=long, dist='weibull')
})

# New individual to estimate transition probabilities for
newdata <- data.frame(age="20-40", dissub="AML")

# Plot pathway diagram at 2-yearly intervals up to 10-years 
time_points <- seq(0, 10, by=2) * 365.25

\donttest{
plot_predicted_pathway(models, tmat, newdata, time_points, 1)
}

}
