% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{vcov.brmcoda}
\alias{vcov.brmcoda}
\title{Covariance and Correlation Matrix of Population-Level Effects}
\usage{
\method{vcov}{brmcoda}(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link{vcov.brmsfit}}.}
}
\value{
covariance or correlation matrix of population-level parameters
}
\description{
Get a point estimate of the covariance or
correlation matrix of population-level parameters
of the \code{brmsfit} object in a \code{brmcoda} object.
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
  formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
    wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")
  
  vcov(m)
}}
}
\seealso{
\code{\link[brms:vcov.brmsfit]{vcov.brmsfit}}
}
