% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.brmcoda}
\alias{summary.brmcoda}
\title{Create a Summary of a fitted \code{brmsfit} model in a \code{brmcoda} object}
\usage{
\method{summary}{brmcoda}(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Other arguments passed to \code{\link{summary.brmsfit}}.}
}
\description{
Create a Summary of a fitted \code{brmsfit} model in a \code{brmcoda} object
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                                 idvar = "ID", total = 1440),
  formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
    wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")
  
  summary(m)
}}
}
