% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{coef.brmcoda}
\alias{coef.brmcoda}
\alias{coef}
\title{Model Coefficients}
\usage{
\method{coef}{brmcoda}(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link{coef.brmsfit}}.}
}
\value{
A list of 3D arrays (one per grouping factor).
 If \code{summary} is \code{TRUE},
 the 1st dimension contains the factor levels,
 the 2nd dimension contains the summary statistics
 (see \code{\link[brms]{posterior_summary}}), and
 the 3rd dimension contains the group-level effects.
 If \code{summary} is \code{FALSE}, the 1st dimension contains
 the posterior draws, the 2nd dimension contains the factor levels,
 and the 3rd dimension contains the group-level effects.
}
\description{
Extract model coefficients, which are the sum of population-level
effects and corresponding group-level effects
of the \code{brmsfit} object in a \code{brmcoda} object.
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  m <- brmcoda(compilr = compilr(data = mcompd, sbp = sbp,
                                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                                 idvar = "ID", total = 1440),
  formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
    wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")
  
  ## extract population and group-level coefficients separately
  fixef(m)
  ranef(m)
  
  ## extract combined coefficients
  coef(m)
}}
}
\seealso{
\code{\link[brms:coef.brmsfit]{coef.brmsfit}}
}
