% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicross.R
\name{mmcm}
\alias{mmcm}
\title{Use the Mahalnobis-type multisample test based on optimal matching to compare K different multivariate distributions}
\usage{
mmcm(data_list, level)
}
\arguments{
\item{data_list}{is list of multifeature matrices corresponding to the K different classes, so each element of the list is a matrix, for a total of K matrices.}

\item{level}{is the cutoff value (alpha) for hypothesis testing}
}
\value{
The p-value corresponding to rejection of the alternative, along with the decision of the hypothesis testing (Null being accepted versus rejected)
}
\description{
Use the Mahalnobis-type multisample test based on optimal matching to compare K different multivariate distributions
}
\examples{
# Simulation Example when the user wants to test whether K=3 multivariate distributions are equal:
X1 = MASS::mvrnorm(10,rep(0,4),diag(2,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
X2 = MASS::mvrnorm(10,rep(0,4),diag(1,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
X3 = MASS::mvrnorm(10,rep(0,4),diag(3,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
mmcm(list(X1,X2,X3), 0.05)
}
