% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{print.summary.bmult_bridge}
\alias{print.summary.bmult_bridge}
\title{print method for class \code{summary.bmult_bridge}}
\usage{
\method{print}{summary.bmult_bridge}(x, ...)
}
\arguments{
\item{x}{object of class \code{summary.bmult_bridge} as returned from \code{\link{summary.bmult_bridge}}}

\item{...}{additional arguments, currently ignored}
}
\value{
The print methods print the summary of the bridge sampling output
}
\description{
Prints the summary of bridge sampling output
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Multinomial Case
out_mult  <- mult_bf_inequality(x=x, Hr=Hr, a=a, factor_levels=factor_levels,
niter=1e3, seed=2020)
summary(out_mult)
}
