% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{unique_combos}
\alias{unique_combos}
\title{Unique combinations of blocks}
\usage{
unique_combos(n_block, max_level, min_level = 2)
}
\arguments{
\item{n_block}{\code{integer} number of input blocks.}

\item{max_level}{\code{integer} maximum number of blocks per combination.}

\item{min_level}{\code{integer} minimum number of blocks per combination.}
}
\value{
A list of unique block combinations.
}
\description{
Compute a list of all possible block combinations where
the number of blocks in each combination is limited by parameters
\code{min_level} and \code{max_level}.
}
\details{
This function is used for minimal redundancy implementations of
\code{\link{rosa}} and \code{\link{sopls}} and for lookups into computed
components.
}
\examples{
unique_combos(3, 2)

}
