% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{msigdbr}
\alias{msigdbr}
\title{Retrieve the gene sets data frame}
\usage{
msigdbr(species = "Homo sapiens", category = NULL, subcategory = NULL)
}
\arguments{
\item{species}{Species name, such as Homo sapiens or Mus musculus.}

\item{category}{MSigDB collection abbreviation, such as H or C1.}

\item{subcategory}{MSigDB sub-collection abbreviation, such as CGP or BP.}
}
\value{
A data frame of gene sets with one gene per row.
}
\description{
Retrieve a data frame of gene sets and their member genes.
The available species and collections can be checked with \code{msigdbr_species()} and \code{msigdbr_collections()}.
}
\examples{
# get all human gene sets
\donttest{msigdbr(species = "Homo sapiens")}

# get mouse C2 (curated) CGP (chemical and genetic perturbations) gene sets
\donttest{msigdbr(species = "Mus musculus", category = "C2", subcategory = "CGP")}
}
\references{
\url{https://www.gsea-msigdb.org/gsea/msigdb/collections.jsp}
}
