% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_gaz_relations.R
\name{gaz_relations}
\alias{gaz_relations}
\alias{gaz_relations.numeric}
\alias{gaz_relations.mr_df}
\title{Walk the hierarchy of the MarineRegions Gazetter given a Gazetteer MRGID or Gazetteer entries}
\usage{
gaz_relations(x, ...)

\method{gaz_relations}{numeric}(x, ...)

\method{gaz_relations}{mr_df}(x, ...)
}
\arguments{
\item{x}{the object from which the relations are retrieved. Can be:
\itemize{
\item (integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID}), passed to \code{\link[=gaz_rest_relations_by_mrgid]{gaz_rest_relations_by_mrgid()}}
\item A data frame retrieved with \link{mregions2} via its functions \code{\link[=gaz_search]{gaz_search()}},
\code{\link[=gaz_search_by_source]{gaz_search_by_source()}} or \code{\link[=gaz_search_by_type]{gaz_search_by_type()}}.
}}

\item{...}{
  Arguments passed on to \code{\link[=gaz_rest_relations_by_mrgid]{gaz_rest_relations_by_mrgid}}
  \describe{
    \item{\code{with_geometry}}{(logical) Add geometries to the result data frame? Default = FALSE}
    \item{\code{direction}}{(character) Must be one of upper, lower, both:
\itemize{
\item \code{upper}: lists all parents of the record.
\item \code{lower}: lists all childs of the record.
\item \code{both}: lists parents and childs of the record (default)
}}
    \item{\code{type}}{(character) Must be one of partof, partlypartof, adjacentto, similarto, administrativepartof, influencedby, all.}
  }}
}
\value{
A data frame with Gazetteer entries
}
\description{
Walk the hierarchy of the MarineRegions Gazetter given a Gazetteer MRGID or Gazetteer entries
}
\details{
You can pass the output of most \verb{gaz_*} functions to \code{gaz_relations()} to retrieve the
related gazetteer entries
\subsection{Developer info}{

This is done in the method \code{\link[=gaz_relations.mr_df]{gaz_relations.mr_df()}}. \code{mr_df} is a class defined in
this package to ensure the data frame passed to gaz_relations has a variable with \link{MRGID}.
}
}
\examples{
\donttest{
# Get the relations of the Belgian Exclusive Economic Zone
gaz_search("Belgian Exclusive Economic Zone") |> gaz_relations()

# Or using its mrgid
gaz_relations(3293)
}
}
