% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.sel.phases}
\alias{summary.sel.phases}
\title{Summarises a sel.phases object}
\usage{
\method{summary}{sel.phases}(object, na.rm = TRUE, ...)
}
\arguments{
\item{object}{\code{sel.phases} object.}

\item{na.rm}{remove missings?}

\item{...}{ignored.}
}
\value{
list of \code{Circular} statistics.
}
\description{
Summarises a sel.phases object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
co <- analyze_coherency(pv, columns = c("Nose_x", "Nose_y"))
sp <- plot_sel_phases(co, pv, sel.period = NULL, sel.lower = 0.5, sel.upper = 0.7)
summary(sp)
}
