% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosum_stat.R
\name{mosum.stat}
\alias{mosum.stat}
\title{MOSUM statistic}
\usage{
mosum.stat(
  x,
  G,
  G.right = NA,
  var.est.method = "mosum",
  var.custom = NULL,
  boundary.extension = TRUE
)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{an integer value for the length of the moving sum window; 
\code{G} should be less than \code{length(n)/2}.
Alternatively a number between \code{0} and \code{0.5} describing the moving sum bandwidth
relative to \code{length(x)}.}

\item{G.right}{iff \code{!is.na(G.right)}, the asymmetric bandwidth (G,G.right) will be used}

\item{var.est.method}{how the variance is estimated;
possible values are
\itemize{
   \item{\code{'custom'}}{a vector of \code{length(x)} is to be parsed by the user; use \code{var.custom} in this case to to so}
   \item{\code{'mosum'}}{both-sided MOSUM variance estimator}
   \item{\code{'mosum.min'}}{minimum of the sample variance estimates from the left and right summation windows}
   \item{\code{'mosum.max'}}{maximum of the sample variance estimates from the left and right summation windows}   
}}

\item{var.custom}{a numeric vector (of the same length as \code{x}) containing
local estimates of the variance or long run variance; use iff \code{var.est.method=custom}}

\item{boundary.extension}{a logical value indicating whether the boundary
values should be filled-up with CUSUM values}
}
\value{
S3 \code{mosum.stat} object, which contains the following fields:
   \item{x}{the numeric input vector provided}
   \item{G.left,G.right}{left and right bandwidths}
   \item{var.est.method,var.custom,boundary.extension}{input parameters}
   \item{stat}{a series of MOSUM statistic values; the first \code{G} and last \code{G.right} values are \code{NA} iff \code{boundary.extension=FALSE}}
   \item{rollsums}{a series of MOSUM detector values; equals \code{stat*sqrt(var.estimation)}}
   \item{var.estimation}{the local variance estimated according to \code{var.est.method}}
}
\description{
Computes the statistical values for the MOSUM test for changes in the mean.
}
\details{
This class only contains the values for the MOSUM statistic.
For statistical evaluation and change point extraction, use \link[mosum]{mosum}.
See also \link[mosum]{multiscale.bottomUp} and \link[mosum]{multiscale.localPrune}.
}
\keyword{internal}
