% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewiseStationary.R
\name{piecewiseStationary_timeSeries}
\alias{piecewiseStationary_timeSeries}
\title{Piecewise stationary model time series}
\usage{
piecewiseStationary_timeSeries(model = c("custom", "blocks", "fms", "mix",
  "stairs10", "teeth10")[1], lengths = NULL, means = NULL, sds = NULL,
  rand.gen = rnorm, seed = NULL, ...)
}
\arguments{
\item{model}{A string indicating which model to be returned; 
possible values are "blocks", "fms", "mix", "stairs10", "teeth10"
(for the referenced model signals) or "custom" (for user specification 
in terms of \code{lengths}, \code{means} and \code{sds})}

\item{lengths}{(use iff model="custom"): integer vector for the lengths of the piecewise stationary parts}

\item{means}{(use iff model="custom"): numeric vector for the means of the piecewise stationary parts}

\item{sds}{(use iff model="custom"): numeric vector for the deviation scaling of the piecewise stationary parts.
The values are multiplied with the outcome of \code{rand.gen}. Note that it corresponds to the standard
deviation in case of standard normal innovations (\code{rand.gen=rnorm})}

\item{rand.gen}{optional: a function to generate the noise/innovations}

\item{seed}{optional: a seed value (if !is.null(seed), then set.seed(seed) is called beforehand)}

\item{...}{further arguments to be parsed to \code{rand.gen}}
}
\value{
numeric vector containing a realization of the time series, given as signal+noise
}
\description{
Create a piecewise stationary model time series (signal+noise)
}
