% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mutUniformResetSHW}
\alias{mutUniformResetSHW}
\alias{mutUniformMetaResetSHW}
\title{Uniform Reset Scaled by Hamming Weight}
\usage{
mutUniformResetSHW(ind, p = 0.1, reset.dist, ...)

mutUniformMetaResetSHW(ind, p = 0.1, reset.dists, reset.dist.weights, ...)
}
\arguments{
\item{ind}{\verb{[integer]} binary individual.}

\item{p}{\verb{[numeric]} average reset probability, must be between 0 and 1.}

\item{reset.dist}{\verb{[numeric]} approximate probability to draw 1-bit per entry.}

\item{...}{further arguments passed on to the method.}

\item{reset.dists}{\verb{[matrix]} columns of probabilities, with \code{length(ind)} cols and
\code{length(reset.dist.weights)} rows.}

\item{reset.dist.weights}{\verb{[numeric]} weight vector to select among \code{reset.dist} columns.}
}
\value{
\verb{[integer]} the mutated individual
}
\description{
Combination of the idea of \code{\link{mutBitflipCHW}} with \code{\link{mutUniformReset}}.

If a given bitvector has \code{m} 1s and \code{n} 0s, then, with probability \code{p} for
each bit, it is drawn anew from the distribution
\code{((m + 1) * reset.dist) / (m * reset.dist + n * (1 - reset.dist) + 1)}.

The reasoning behind this is that, without Laplace smoothing, drawing from
\code{m * reset.dist} / (m * reset.dist + n * (1 - reset.dist))\verb{would lead to probabilities of drawing a "0" or "1" such that}mean(P("1") / P("0")) = m / n * mean(reset.dist / (1 - reset.dist))`.

The \code{mutUniformMetaResetSHW} does reset with a weighted mean of distributions.
}
