% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moranajp.R
\name{moranajp_all}
\alias{moranajp_all}
\alias{moranajp}
\alias{make_cmd_mecab}
\alias{out_cols_mecab}
\alias{mecab_all}
\alias{mecab}
\title{Morphological analysis for a specific column in dataframe}
\usage{
moranajp_all(tbl, bin_dir, text_col = "text", option = "")

moranajp(tbl, bin_dir, option = "")

make_cmd_mecab(tbl, bin_dir, option = "")

out_cols_mecab()

mecab_all(tbl, text_col = "text", bin_dir = "")

mecab(tbl, bin_dir)
}
\arguments{
\item{tbl}{A tibble or data.frame.}

\item{bin_dir}{A text. Directory of mecab.}

\item{text_col}{A text. Colnames for morphological analysis.}

\item{option}{A text. Options for mecab.
"-b" option is already set by moranajp.
See by "mecab -h".}
}
\value{
A tibble.   Output of 'MeCab' and added column "text_id".
}
\description{
Using 'MeCab' for morphological analysis.
Keep other colnames in dataframe.
}
\examples{
\dontrun{
  library(tidyverse)
  data(neko)
  neko <-
      neko \%>\%
      dplyr::mutate(text=stringi::stri_unescape_unicode(text)) \%>\%
      dplyr::mutate(cols=1:nrow(.))
  moranajp_all(neko, text_col = "text") \%>\%
      print(n=100)
}
}
