% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circ_dist.R
\name{circ_dist}
\alias{circ_dist}
\title{Distance Matrix of Circular Variables}
\usage{
circ_dist(frame)
}
\arguments{
\item{frame}{A data frame with all columns are circular measured in degrees.}
}
\value{
Object of class "dist".
}
\description{
Calculates the distance matrix of observations with circular variables using
an adapted version of Gower's distance. This distance should be compatible
with the Gower's distance for other variable types.
}
\details{
The distance between two observations {i} and {j} of a circular variable {q}
is suggested to be

\deqn{(y_{iq}, y_{jq}) = \frac{180 - |180 - |y_{iq} - y_{jq}||}{180}.}
}
\examples{
# Make a sample data set of 20 observations with 2 circular variables
data <- data.frame(var1 = sample.int(359, 20),
                   var2 = sample.int(359, 20))
circ_dist(data)
}
\references{
\itemize{
\item Tran, T. V. (2019). Chapter 3. Monothetic Cluster Analysis with Extensions
to Circular and Functional Data. Montana State University - Bozeman.
}
}
\seealso{
\code{\link[stats:dist]{stats::dist()}}
}
