% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yardstick-metric-sets.R
\name{metric_sets}
\alias{metric_sets}
\alias{default_forecast_accuracy_metric_set}
\alias{extended_forecast_accuracy_metric_set}
\title{Forecast Accuracy Metrics Sets}
\usage{
default_forecast_accuracy_metric_set(...)

extended_forecast_accuracy_metric_set(...)
}
\arguments{
\item{...}{Add additional \code{yardstick} metrics}
}
\description{
This is a wrapper for \code{metric_set()} with several common forecast / regression
accuracy metrics included. These are the default time series accuracy
metrics used with \code{\link[=modeltime_accuracy]{modeltime_accuracy()}}.
}
\section{Default Forecast Accuracy Metric Set}{
The primary purpose is to use the default accuracy metrics to calculate the following
forecast accuracy metrics using \code{\link[=modeltime_accuracy]{modeltime_accuracy()}}:
\itemize{
\item MAE   - Mean absolute error, \code{mae()}
\item MAPE  - Mean absolute percentage error, \code{mape()}
\item MASE  - Mean absolute scaled error, \code{mase()}
\item SMAPE - Symmetric mean absolute percentage error, \code{smape()}
\item RMSE  - Root mean squared error, \code{rmse()}
\item RSQ   - R-squared, \code{rsq()}
}

Adding additional metrics is possible via \code{...}.
}

\section{Extended Forecast Accuracy Metric Set}{
Extends the default metric set by adding:
\itemize{
\item MAAPE - Mean Arctangent Absolute Percentage Error, \code{\link[=maape]{maape()}}.
MAAPE is designed for intermittent data where MAPE returns \code{Inf}.
}
}

\examples{
library(tibble)
library(dplyr)
library(timetk)
library(yardstick)

fake_data <- tibble(
    y    = c(1:12, 2*1:12),
    yhat = c(1 + 1:12, 2*1:12 - 1)
)

# ---- HOW IT WORKS ----

# Default Forecast Accuracy Metric Specification
default_forecast_accuracy_metric_set()

# Create a metric summarizer function from the metric set
calc_default_metrics <- default_forecast_accuracy_metric_set()

# Apply the metric summarizer to new data
calc_default_metrics(fake_data, y, yhat)

# ---- ADD MORE PARAMETERS ----

# Can create a version of mase() with seasonality = 12 (monthly)
mase12 <- metric_tweak(.name = "mase12", .fn = mase, m = 12)

# Add it to the default metric set
my_metric_set <- default_forecast_accuracy_metric_set(mase12)
my_metric_set

# Apply the newly created metric set
my_metric_set(fake_data, y, yhat)


}
\seealso{
\itemize{
\item \code{\link[yardstick:metric_tweak]{yardstick::metric_tweak()}} - For modifying \code{yardstick} metrics
}
}
