% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_joined_between.R
\name{mnis_joined_between}
\alias{mnis_joined_between}
\title{Members who joined between two dates.}
\usage{
mnis_joined_between(
  start_date = "1900-01-01",
  end_date = Sys.Date(),
  house = "all",
  party = NULL,
  eligible = "all",
  tidy = TRUE,
  tidy_style = "snake_case"
)
}
\arguments{
\item{start_date}{The start date of the search, Accepts character values in
\code{'YYYY-MM-DD'} format, and objects of class \code{Date},
\code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else than can
be coerced to a date with \code{as.Date()}. Defaults to \code{'1900-01-01'}.}

\item{end_date}{The end date of the search. Accepts character values in
\code{'YYYY-MM-DD'} format, and objects of class \code{Date},
\code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else than can be
coerced to a date with \code{as.Date()}. Defaults to the current system date.}

\item{house}{The house to which the member belongs. Accepts one of
\code{'all'}, \code{'lords'} and \code{'commons'}. This parameter is
not case sensitive. Defaults to \code{'all'}.}

\item{party}{All members from a given party who joined between the two
dates. The party name must be fully spelled out (e.g. \code{'green party'}),
the API does not accept searches on this parameter. For a tibble of
parties, see \code{\link[=ref_parties]{ref_parties()}}.
This parameter is not case sensitive. Defaults to \code{NULL}.}

\item{eligible}{If the member is currently eligible to sit. Accepts
one of \code{'all'}, \code{'current'}, \code{'former'}. This parameter
is not case sensitive. Defaults to \code{'all'}.}

\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\value{
A tibble with data on all members who joined
between the two given dates.
}
\description{
Function returns all members who took their seats in the house between
two given dates.
}
\examples{
\dontrun{
x <- mnis_joined_between(
  start_date = "2015-01-01",
  end_date = "2017-01-01", party = "labour"
)
}

}
