library("MASS") # for Boston Housing data
library("sm")
h<-hist(Boston$medv, plot=F)
cmedv<-cut(Boston$medv, h$breaks)
tab <- table(Boston$chas, cmedv)
tab <- prop.table(tab, 2)
pdf("cdplot.pdf", bg="transparent", width=10, height=6)
layout(matrix(c(1,2,3,3),2,2,byrow=TRUE))
par(mar=c(4,4,2,1))
barplot(tab, axes=F, space=0)
cdplot(Boston$medv, factor(Boston$chas), main="cdplot")
sm.density.compare(Boston$medv, factor(Boston$chas), col=c("red", "blue"), lty=c("solid", "solid"))
title("sm.density.compare")
dev.off()