\name{prmu.time}
\alias{prmu.time}
\title{Estimated mean and probabilities for Model 2 and 3}
\usage{
  prmu.time(M, Xk, beta, u1, u2)
}
\arguments{
  \item{M}{vector with the area sample sizes.}

  \item{Xk}{list of matrices with the auxiliary variables
  per category obtained from \code{\link[mme]{data.mme}}.
  The dimension of the list is the number of domains.}

  \item{beta}{a list with the values for the fixed effects
  beta per category obtained from
  \code{\link[mme]{modelfit2}}.}

  \item{u1}{a vector with the values of the first random
  effect obtained from \code{\link[mme]{modelfit2}} or
  \code{\link[mme]{modelfit3}}.}

  \item{u2}{a vector with the values of the second random
  effect obtained from \code{\link[mme]{modelfit2}} or
  \code{\link[mme]{modelfit3}}.}
}
\value{
  A list containing the following components:
  \item{Estimated.probabilities}{matrix with the estimated
  probabilities for the categories of response variable.}
  \item{mean}{matrix with the estimated mean of the
  response variable.} \item{eta}{matrix with the estimated
  log-rates of the probabilities of each category over the
  reference category.}
}
\description{
  This function calculates the estimated probabilities and
  the estimated mean of the response variable, in the
  multinomial mixed models with two independent random
  effects, one random effect associated with the area and
  the other associated with the time, for each category of
  the response variable. The first model assumes
  independent time and domain random effect (Model 2) and
  the second model assumes correlated time and domain
  random effect (Model 3).
}
\examples{
require(Matrix)

k=3 #number of categories of the response variable
pp=c(1,1) #vector with the number of auxiliary variables in each category
mod=2 #Type of model
data(simdata2) # data
datar=data.mme(simdata2,k,pp,mod)
initial=datar$initial

## Estimated mean and estimated probabilities
mean=prmu.time(datar$n,datar$Xk,initial$beta.0,initial$u1.0,initial$u2.0)
}
\references{
  Lopez-Vizcaino, ME, Lombardia, MJ and Morales, D (2013).
  Small area estimation of labour force indicator under a
  multinomial mixed model with correlated time and area
  effects. Submited for review.
}
\seealso{
  \code{\link[mme]{data.mme}},
  \code{\link[mme]{initial.values}},
  \code{\link[mme]{wmatrix}},
  \code{\link[mme]{phi.mult.it}},
  \code{\link[mme]{Fbetaf.it}},
  \code{\link[mme]{phi.direct.it}},
  \code{\link[mme]{sPhikf.it}}, \code{\link[mme]{ci}},
  \code{\link[mme]{modelfit2}}, \code{\link[mme]{msef.it}},
  \code{\link[mme]{mseb}}
}
\keyword{models}

