% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverter.R
\name{invert}
\alias{invert}
\title{Invert Target Preprocessing}
\usage{
invert(inverter, prediction, predict.type = "response")
}
\arguments{
\item{inverter}{[\code{CPOInverter}]\cr
The retrafo or inverter to apply}

\item{prediction}{[\code{\link[mlr]{Prediction}} | \code{matrix} | \code{data.frame}]\cr
The prediction to invert}

\item{predict.type}{[\code{character(1)}]\cr
The equivalent to the \code{predict.type} property of a \code{\link[mlr:makeLearner]{Learner}}] object,
control what kind of prediction to perform. One of \dQuote{response}, \dQuote{se},
\dQuote{prob}. Default is \dQuote{response}. Care must be taken that the \code{prediction} was generated
with a prediction type that fits this, i.e. it must be of type \code{getCPOPredictType(inverter)[predict.type]}.}
}
\value{
[\code{\link[mlr]{Prediction}} | \code{data.frame}]. A transformed \code{\link{Prediction}} if a prediction was given,
  or a \code{data.frame}. If the first object in the chain is a \code{CPORetrafo} object, the \sQuote{truth} column(s) of the
  prediction will be dropped.
}
\description{
Invert the transformation, done on the target column(s)
of a data set, after prediction.

Use either a \code{\link{CPORetrafo}} object with invert capability (see \code{\link{getCPOTrainedCapability}},
or a \code{\link{CPOInverter}} retrieved with
\code{\link{inverter}} from a data object that was fed through a retrafo
chain.

If a \code{\link{CPORetrafo}} object is used that contains no target-bound transformations
(i.e. has \dQuote{invert} capability 0), this is a no-op.
}
