% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskRegrST.R
\name{TaskRegrST}
\alias{TaskRegrST}
\title{Create a Spatiotemporal Regression Task}
\description{
This task specializes \link{Task} and \link{TaskSupervised} for spatiotemporal
classification problems.

A spatial example task is available via \code{tsk("ecuador")}, a spatiotemporal
one via \code{tsk("cookfarm_mlr3")}.

The coordinate reference system passed during initialization must match the
one which was used during data creation, otherwise offsets of multiple meters
may occur. By default, coordinates are not used as features. This can be
changed by setting \code{coords_as_features = TRUE}.
}
\seealso{
Other Task: 
\code{\link{TaskClassifST}},
\code{\link{mlr_tasks_cookfarm}},
\code{\link{mlr_tasks_diplodia}},
\code{\link{mlr_tasks_ecuador}}
}
\concept{Task}
\section{Super classes}{
\code{\link[mlr3:Task]{mlr3::Task}} -> \code{\link[mlr3:TaskSupervised]{mlr3::TaskSupervised}} -> \code{\link[mlr3:TaskRegr]{mlr3::TaskRegr}} -> \code{TaskRegrST}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{crs}}{(\code{character(1)})\cr
Returns coordinate reference system of task.}

\item{\code{coordinate_names}}{(\code{character()})\cr
Coordinate names.}

\item{\code{coords_as_features}}{(\code{logical(1)})\cr
If \code{TRUE}, coordinates are used as features.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TaskRegrST-new}{\code{TaskRegrST$new()}}
\item \href{#method-TaskRegrST-coordinates}{\code{TaskRegrST$coordinates()}}
\item \href{#method-TaskRegrST-print}{\code{TaskRegrST$print()}}
\item \href{#method-TaskRegrST-clone}{\code{TaskRegrST$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="add_strata"><a href='../../mlr3/html/Task.html#method-Task-add_strata'><code>mlr3::Task$add_strata()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="cbind"><a href='../../mlr3/html/Task.html#method-Task-cbind'><code>mlr3::Task$cbind()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="data"><a href='../../mlr3/html/Task.html#method-Task-data'><code>mlr3::Task$data()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="droplevels"><a href='../../mlr3/html/Task.html#method-Task-droplevels'><code>mlr3::Task$droplevels()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="filter"><a href='../../mlr3/html/Task.html#method-Task-filter'><code>mlr3::Task$filter()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="format"><a href='../../mlr3/html/Task.html#method-Task-format'><code>mlr3::Task$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="formula"><a href='../../mlr3/html/Task.html#method-Task-formula'><code>mlr3::Task$formula()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="head"><a href='../../mlr3/html/Task.html#method-Task-head'><code>mlr3::Task$head()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="help"><a href='../../mlr3/html/Task.html#method-Task-help'><code>mlr3::Task$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="levels"><a href='../../mlr3/html/Task.html#method-Task-levels'><code>mlr3::Task$levels()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="missings"><a href='../../mlr3/html/Task.html#method-Task-missings'><code>mlr3::Task$missings()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rbind"><a href='../../mlr3/html/Task.html#method-Task-rbind'><code>mlr3::Task$rbind()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rename"><a href='../../mlr3/html/Task.html#method-Task-rename'><code>mlr3::Task$rename()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="select"><a href='../../mlr3/html/Task.html#method-Task-select'><code>mlr3::Task$select()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_col_roles"><a href='../../mlr3/html/Task.html#method-Task-set_col_roles'><code>mlr3::Task$set_col_roles()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_levels"><a href='../../mlr3/html/Task.html#method-Task-set_levels'><code>mlr3::Task$set_levels()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_row_roles"><a href='../../mlr3/html/Task.html#method-Task-set_row_roles'><code>mlr3::Task$set_row_roles()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskRegr" data-id="truth"><a href='../../mlr3/html/TaskRegr.html#method-TaskRegr-truth'><code>mlr3::TaskRegr$truth()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskRegrST-new"></a>}}
\if{latex}{\out{\hypertarget{method-TaskRegrST-new}{}}}
\subsection{Method \code{new()}}{
Create a new spatiotemporal resampling Task
Returns coordinates of observations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskRegrST$new(
  id,
  backend,
  target,
  label = NA_character_,
  coordinate_names,
  crs = NA_character_,
  coords_as_features = FALSE,
  extra_args = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{backend}}{(\link{DataBackend})\cr
Either a \link{DataBackend}, or any object which is convertible to a
\link{DataBackend} with \code{as_data_backend()}.
E.g., am \code{sf} will be converted to a \link{DataBackendDataTable}.}

\item{\code{target}}{(\code{character(1)})\cr
Name of the target column.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance. Shown in \code{as.data.table(mlr_tasks)}.}

\item{\code{coordinate_names}}{(\code{character(1)})\cr
The column names of the coordinates in the data.}

\item{\code{crs}}{(\code{character(1)})\cr
Coordinate reference system.
WKT2 or EPSG string.}

\item{\code{coords_as_features}}{(\code{logical(1)})\cr
If \code{TRUE}, coordinates are used as features.}

\item{\code{extra_args}}{(named \code{list()})\cr
Named list of constructor arguments, required for converting task types
via \code{\link[=convert_task]{convert_task()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskRegrST-coordinates"></a>}}
\if{latex}{\out{\hypertarget{method-TaskRegrST-coordinates}{}}}
\subsection{Method \code{coordinates()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskRegrST$coordinates(row_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{row_ids}}{(\code{integer()})\cr
Vector of rows indices as subset of \code{task$row_ids}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskRegrST-print"></a>}}
\if{latex}{\out{\hypertarget{method-TaskRegrST-print}{}}}
\subsection{Method \code{print()}}{
Print the task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskRegrST$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed to the \verb{$print()} method of the superclass.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskRegrST-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TaskRegrST-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskRegrST$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
