% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpDistrCompositor.R
\name{mlr_pipeops_compose_distr}
\alias{mlr_pipeops_compose_distr}
\alias{PipeOpDistrCompositor}
\title{PipeOpDistrCompositor}
\description{
Estimates (or 'composes') a survival distribution from a predicted baseline \code{distr} and a
\code{crank} or \code{lp} from two \link{PredictionSurv}s.

Compositor Assumptions:
\itemize{
\item The baseline \code{distr} is a discrete estimator, e.g. \link[=LearnerSurvKaplan]{surv.kaplan}.
\item The composed \code{distr} is of a linear form
\item If \code{lp} is missing then \code{crank} is equivalent
}

These assumptions are strong and may not be reasonable. Future updates will upgrade this
compositor to be more flexible.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops} or with the associated sugar
function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:\preformatted{PipeOpDistrCompositor$new()
mlr_pipeops$get("distrcompose")
po("distrcompose")
}
}

\section{Input and Output Channels}{

\link{PipeOpDistrCompositor} has two input channels, "base" and "pred". Both input channels take
\code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpDistrCompositor} has one output channel named "output", producing \code{NULL} during training
and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the "pred" input but with an extra
(or overwritten) column for \code{distr} predict type; which is composed from the \code{distr} of "base"
and \code{lp} or \code{crank} of "pred".
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

The parameters are:
\itemize{
\item \code{form} :: \code{character(1)} \cr
Determines the form that the predicted linear survival model should take. This is either,
accelerated-failure time, \code{aft}, proportional hazards, \code{ph}, or proportional odds, \code{po}.
Default \code{aft}.
\item \code{overwrite} :: \code{logical(1)} \cr
If \code{FALSE} (default) then if the "pred" input already has a \code{distr}, the compositor does
nothing and returns the given \link{PredictionSurv}. If \code{TRUE} then the \code{distr} is overwritten
with the \code{distr} composed from \code{lp}/\code{crank} - this is useful for changing the prediction
\code{distr} from one model form to another.
}
}

\section{Internals}{

The respective \code{form}s above have respective survival distributions:
\deqn{aft: S(t) = S_0(\frac{t}{exp(lp)})}{aft: S(t) = S0(t/exp(lp))}
\deqn{ph: S(t) = S_0(t)^{exp(lp)}}{ph: S(t) = S0(t)^exp(lp)}
\deqn{po: S(t) = \frac{S_0(t)}{exp(-lp) + (1-exp(-lp)) S_0(t)}}{po: S(t) = S0(t) / [exp(-lp) + S0(t) (1-exp(-lp))]} # nolint
where \eqn{S_0}{S0} is the estimated baseline survival distribution, and \eqn{lp} is the
predicted linear predictor. If the input model does not predict a linear predictor then \code{crank}
is assumed to be the \code{lp} - \strong{this may be a strong and unreasonable assumption.}
}

\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library(mlr3)
  library(mlr3pipelines)
  task = tsk("rats")

  base = lrn("surv.kaplan")$train(task)$predict(task)
  pred = lrn("surv.coxph")$train(task)$predict(task)
  pod = po("distrcompose", param_vals = list(form = "aft", overwrite = TRUE))
  pod$predict(list(base = base, pred = pred))[[1]]
}
}
}
\seealso{
\link{pipeline_distrcompositor}

Other survival compositors: 
\code{\link{mlr_pipeops_compose_crank}}
}
\concept{survival compositors}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpDistrCompositor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpDistrCompositor$new()}}
\item \href{#method-clone}{\code{PipeOpDistrCompositor$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpDistrCompositor$new(
  id = "compose_distr",
  param_vals = list(form = "aft", overwrite = FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpDistrCompositor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
