% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvRandomForestSRC.R
\name{LearnerSurvRandomForestSRC}
\alias{LearnerSurvRandomForestSRC}
\alias{mlr_learners_surv.randomForestSRC}
\title{RandomForestSRC Survival Forest Survival Learner}
\description{
Calls \code{\link[randomForestSRC:rfsrc]{randomForestSRC::rfsrc()}}.
\itemize{
\item distr is predicted using \code{\link[randomForestSRC:predict.rfsrc]{randomForestSRC::predict.rfsrc()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}

\code{\link[randomForestSRC:predict.rfsrc]{randomForestSRC::predict.rfsrc()}} returns both cumulative hazard function (chf) and survival function (surv)
but uses different estimators to derive these. \code{chf} uses a bootstrapped Nelson-Aalen estimator,
(Ishwaran, 2008) whereas \code{surv} uses a bootstrapped Kaplan-Meier estimator \url{https://kogalur.github.io/randomForestSRC/theory.html}.
The choice of which estimator to use is given by the extra \code{estimator} hyper-parameter,
default is \code{nelson}.
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:lrn]{lrn()}:\preformatted{LearnerSurvRandomForestSRC$new()
mlr_learners$get("surv.randomForestSRC")
lrn("surv.randomForestSRC")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{logical, integer, numeric, factor, ordered}
\item Properties: \verb{importance, missings, weights}
\item Packages: \CRANpkg{randomForestSRC} \CRANpkg{distr6}
}
}

\references{
Ishwaran H. and Kogalur U.B. (2019). Fast Unified Random Forests for Survival,
Regression, and Classification (RF-SRC), R package version 2.9.1.

\cite{mlr3proba}{ishwaran_2008}

\cite{mlr3proba}{breiman_2001}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvXgboost}}
}
\concept{survival learners}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerSurv]{mlr3proba::LearnerSurv}} -> \code{LearnerSurvRandomForestSRC}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerSurvRandomForestSRC$new()}}
\item \href{#method-importance}{\code{LearnerSurvRandomForestSRC$importance()}}
\item \href{#method-selected_features}{\code{LearnerSurvRandomForestSRC$selected_features()}}
\item \href{#method-clone}{\code{LearnerSurvRandomForestSRC$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvRandomForestSRC$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-importance"></a>}}
\if{latex}{\out{\hypertarget{method-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are extracted from the model slot \code{variable.importance}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvRandomForestSRC$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-selected_features"></a>}}
\if{latex}{\out{\hypertarget{method-selected_features}{}}}
\subsection{Method \code{selected_features()}}{
Selected features are extracted from the model slot \code{frame$var}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvRandomForestSRC$selected_features()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvRandomForestSRC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
