% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvIntegrated.R
\name{MeasureSurvIntegrated}
\alias{MeasureSurvIntegrated}
\title{Abstract Class for Integrated Measures}
\description{
This is an abstract class that should not be constructed directly.
}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvIntegrated}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{integrated}}{\code{(logical(1))}
Returns if the measure should be integrated or not.
Settable.}

\item{\code{times}}{\code{(numeric())}
Returns the times at which the measure should be evaluated at, or integrated over.
Settable.}

\item{\code{method}}{\code{(integer(1))}
Returns which method is used for approximating integration.
Settable.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MeasureSurvIntegrated$new()}}
\item \href{#method-clone}{\code{MeasureSurvIntegrated$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate">}\href{../../mlr3/html/Measure.html#method-aggregate}{\code{mlr3::Measure$aggregate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format">}\href{../../mlr3/html/Measure.html#method-format}{\code{mlr3::Measure$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help">}\href{../../mlr3/html/Measure.html#method-help}{\code{mlr3::Measure$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print">}\href{../../mlr3/html/Measure.html#method-print}{\code{mlr3::Measure$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score">}\href{../../mlr3/html/Measure.html#method-score}{\code{mlr3::Measure$score()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
This is an abstract class that should not be constructed directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvIntegrated$new(
  integrated = TRUE,
  times,
  method = 2,
  id,
  range,
  minimize,
  packages,
  predict_type,
  properties
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{integrated}}{(\code{logical(1)})\cr
If \code{TRUE} (default), returns the integrated score; otherwise, not integrated.}

\item{\code{times}}{(\code{numeric()})\cr
If \code{integrate == TRUE} then a vector of time-points over which to integrate the score.
If \code{integrate == FALSE} then a single time point at which to return the score.}

\item{\code{method}}{(\code{integer(1)})\cr
If \code{integrate == TRUE} selects the integration weighting method.
\code{method == 1} corresponds to weighting each time-point equally and taking the mean score over
discrete time-points. \code{method == 2} corresponds to calculating a mean weighted by the difference
between time-points. \code{method == 2} is default to be in line with other packages.}

\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{range}}{(\code{numeric(2)})\cr
Feasible range for this measure as \code{c(lower_bound, upper_bound)}.
Both bounds may be infinite.}

\item{\code{minimize}}{(\code{logical(1)})\cr
Set to \code{TRUE} if good predictions correspond to small values,
and to \code{FALSE} if good predictions correspond to large values.
If set to \code{NA} (default), tuning this measure is not possible.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled by the constructor if at least one of the packages is not installed,
but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{predict_type}}{(\code{character(1)})\cr
Required predict type of the \link{Learner}.
Possible values are stored in \link[=mlr_reflections]{mlr_reflections$learner_predict_types}.}

\item{\code{properties}}{(\code{character()})\cr
Properties of the measure.
Must be a subset of \link[=mlr_reflections]{mlr_reflections$measure_properties}.
Supported by \code{mlr3}:
\itemize{
\item \code{"requires_task"} (requires the complete \link{Task}),
\item \code{"requires_learner"} (requires the trained \link{Learner}),
\item \code{"requires_train_set"} (requires the training indices from the \link{Resampling}), and
\item \code{"na_score"} (the measure is expected to occasionally return \code{NA} or \code{NaN}).
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvIntegrated$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
