% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish_task.R
\name{publish_task}
\alias{publish_task}
\title{Publish a task on OpenML}
\usage{
publish_task(
  id,
  type,
  estimation_procedure,
  target,
  api_key = NULL,
  test_server = test_server_default()
)
}
\arguments{
\item{id}{(\code{integer(1)})\cr
The dataset id.}

\item{type}{(\code{character(1)} or \code{integer(1)})\cr
Can either be \code{"classif"} or \code{"regr"} or an integer indicating the task type.}

\item{estimation_procedure}{(\code{integer(1)})\cr
The id of the estimation procedure.}

\item{target}{(\code{character(1)})\cr
The target variable (if applicable).}

\item{api_key}{(\code{character(1)})
The API key to perform the action, if left NULL it first tries the "mlr3oml.api_key" R option and
then the environment variable \code{OPENMLAPIKEY}.

In case \code{test_server} is TRUE (only relevant for developers) the test server API key is used, i.e. first the option
"mlr3oml.test_api_key" and then the environment variable \code{TESTOPENMLAPIKEY}.}

\item{test_server}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\description{
Publish a task on OpenML.
This can also be achieved through the \href{https://openml.org}{website}.
}
