% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct_values.R
\name{distinct_values}
\alias{distinct_values}
\title{Get Distinct Values}
\usage{
distinct_values(x, drop = TRUE, na_rm = TRUE)
}
\arguments{
\item{x}{(atomic \code{vector()}).}

\item{drop}{:: \code{logical(1)}\cr
If \code{TRUE}, only returns values which are present in \code{x}.
If \code{FALSE}, returns all levels for \code{\link[=factor]{factor()}} and \code{\link[=ordered]{ordered()}}, as well as
\code{TRUE} and \code{FALSE} for \code{\link[=logical]{logical()}}s.}

\item{na_rm}{:: \code{logical(1)}\cr
If \code{TRUE}, missing values are removed from the vector of distinct values.}
}
\value{
(atomic \code{vector()}) with distinct values in no particular order.
}
\description{
Extracts the distinct values of an atomic vector, with the possibility to drop levels
and remove missing values.
}
\examples{
# for factors:
x = factor(c(letters[1:2], NA), levels = letters[1:3])
distinct_values(x)
distinct_values(x, na_rm = FALSE)
distinct_values(x, drop = FALSE)
distinct_values(x, drop = FALSE, na_rm = FALSE)

# for logicals:
distinct_values(TRUE, drop = FALSE)

# for numerics:
distinct_values(sample(1:3, 10, replace = TRUE))
}
