#' Monitoring Zones
#'
#' @description A dataset describing the locations of depth-discrete monitoring zones
#'   within the multilevel completions of wells in the U.S. Geological Survey (USGS)
#'   aquifer-monitoring network, Idaho National Laboratory (INL), Idaho.
#'   These zones enable precise measurements at various depths,
#'   where groundwater is vertically isolated between upper and lower packers within each well.
#'
#' @format A data frame with the following variables:
#'   \describe{
#'     \item{`site_nm`}{Local site name for a MLMS well.}
#'     \item{`zone_nu`}{Identifier for the depth-discrete monitoring zone,
#'       where groundwater in this zone is vertically isolated between upper and lower packers.}
#'     \item{`zone_top_va`}{Depth to the bottom of the uppermost adjacent packer,
#'       in feet below land surface (ft bls).}
#'     \item{`zone_bot_va`}{Depth to the top of the lowermost adjacent packer, in ft bls.}
#'     \item{`zone_top_alt_va`}{Altitude of the bottom of the uppermost adjacent packer,
#'       in feet above the North American Vertical Datum of 1988 (NAVD 88).}
#'     \item{`zone_bot_alt_va`}{Altitude of the top of the lowermost adjacent packer,
#'       in feet above the NAVD 88.}
#'     \item{`zone_len_va`}{Distance between packer seals or zone, length in feet.}
#'     \item{`nports`}{Number of measurement ports within monitoring zone.}
#'   }
#'
#' @source The dataset originates from the USGS INL Project Office
#'   and underwent processing using the [`read_mlms_json`] function.
#'
#' @keywords datasets
#'
#' @examples
#' str(zones)

"zones"
