% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmc.R
\name{mlmc}
\alias{mlmc}
\title{Multi-level Monte Carlo estimation}
\usage{
mlmc(Lmin, Lmax, N0, eps, mlmc_l, alpha = NA, beta = NA, gamma,
  parallel = NA, ...)
}
\arguments{
\item{Lmin}{the minimum level of refinement.  Must be \eqn{\ge 2}.}

\item{Lmax}{the maximum level of refinement.  Must be \eqn{\ge} Lmin.}

\item{N0}{initial number of samples which are used for the first 3 levels and
for any subsequent levels which are automatically added.  Must be
\eqn{> 0}.}

\item{eps}{the target accuracy of the estimate.  Must be \eqn{> 0}.}

\item{mlmc_l}{a user supplied function which provides the estimate for level
l}

\item{alpha}{the weak error, \eqn{O(2^{-alpha*l})}.  If \code{NA} then
\code{alpha} will be estimated.}

\item{beta}{the variance, \eqn{O(2^{-beta*l})}.  If \code{NA} then
\code{beta} will be estimated.}

\item{gamma}{the sample cost, \eqn{O(2^{gamma*l})}.  Must be \eqn{> 0}.}

\item{parallel}{if an integer is supplied, R will fork \code{parallel} parallel
processes an compute each level estimate in parallel.}

\item{...}{additional arguments which are passed on when the user supplied
\code{mlmc_l} function is called}
}
\value{
A list containing: \describe{
  \item{\code{P}}{The MLMC estimate;}
  \item{\code{Nl}}{A vector of the number of samples performed on each level.}
}
}
\description{
This function is the Multi-level Monte Carlo driver which will sample from the levels of user specified function.
}
\details{
Multilevel Monte Carlo Method method originated in works Giles (2008) and Heinrich (1998).

Consider  a sequence \eqn{P_0, P_1, \ldots,} which approximates \eqn{P_L} with
increasing accuracy, but also increasing cost, we have the simple identity
\deqn{E[P_L] = E[P_0] + \sum_{l=1}^L E[P_l-P_{l-1}],}
and therefore we can use the following unbiased estimator for \eqn{E[P_L]},
\deqn{N_0^{-1} \sum_{n=1}^{N_0} P_0^{(0,n)} +
\sum_{l=1}^L \{
N_l^{-1} \sum_{n=1}^{N_l} (P_l^{(l,n)} - P_{l-1}^{(l,n)})
\}}
with the inclusion of the level \eqn{l} in the superscript \eqn{(l,n)} indicating
that the samples used at each level of correction are independent.

Set \eqn{C_0}, and \eqn{V_0} to be the cost and variance of one sample of \eqn{P_0},
and \eqn{C_l, V_l} to be the cost and variance of one sample of \eqn{P_l - P_{l-1}},
then the overall cost and variance of the multilevel estimator is
\eqn{\sum_{l=0}^L N_l C_l\}}
and
\eqn{\sum_{l=0}^L N_l^{-1} V_l},
respectively.

The idea begind the method, is that provided that the product \eqn{V_l C_l}
decreases with \eqn{l}, i.e. the cost increases with level slower than the
variance decreases, then one can achieve significant computational savings,
which can be formalised as in Theorem 1 of Giles (2015).

For further information on multilevel Monte Carlo methods, see the webpage
\url{http://people.maths.ox.ac.uk/gilesm/mlmc_community.html}
which lists the research groups working in the area, and their
main publications.

This function is based on GPL-2 'Matlab' code by Mike Giles.
}
\examples{
mlmc(2, 6, 1000, 0.01, opre_l, gamma=1, option=1)

mlmc(2, 10, 1000, 0.01, mcqmc06_l, gamma=1, option=1)

}
\author{
Louis Aslett <aslett@stats.ox.ac.uk>

Mike Giles <Mike.Giles@maths.ox.ac.uk>

Tigran Nagapetyan <nagapetyan@stats.ox.ac.uk>
}
\references{
M.B. Giles. Multilevel Monte Carlo path simulation. \emph{Operations Research}, 56(3):607-617, 2008.

M.B. Giles. Multilevel Monte Carlo methods. \emph{Acta Numerica}, 24:259-328, 2015.

S. Heinrich. Monte Carlo complexity of global solution of integral equations. \emph{Journal of Complexity}, 14(2):151-175, 1998.
}

