% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-runs.R
\name{mlflow_log_artifact}
\alias{mlflow_log_artifact}
\title{Log Artifact}
\usage{
mlflow_log_artifact(path, artifact_path = NULL, run_id = NULL,
  client = NULL)
}
\arguments{
\item{path}{The file or directory to log as an artifact.}

\item{artifact_path}{Destination path within the run's artifact URI.}

\item{run_id}{Run ID.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Logs a specific file or directory as an artifact for a run.
}
\details{
When logging to Amazon S3, ensure that you have the s3:PutObject, s3:GetObject,
s3:ListBucket, and s3:GetBucketLocation permissions on your bucket.

Additionally, at least the \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY}
environment variables must be set to the corresponding key and secrets provided
by Amazon IAM.
}
