% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotFMort}
\alias{plotFMort}
\alias{plotlyFMort}
\title{Plot total fishing mortality of each species by size}
\usage{
plotFMort(
  object,
  species = NULL,
  time_range,
  all.sizes = FALSE,
  highlight = NULL,
  ...
)

plotlyFMort(object, species = NULL, time_range, highlight = NULL, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{MizerSim} or
\linkS4class{MizerParams}.}

\item{species}{The species to be selected. Optional. By default all target
species are selected. A vector of species names, or a
numeric vector with the species indices, or a logical vector indicating for
each species whether it is to be selected (TRUE) or not.}

\item{time_range}{The time range (either a vector of values, a vector of min
and max time, or a single value) to average the abundances over. Default is
the final time step. Ignored when called with a \linkS4class{MizerParams}
object.}

\item{all.sizes}{If TRUE, then fishing mortality is plotted also for sizes
outside a species' size range. Default FALSE.}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{...}{Other arguments (currently unused)}
}
\value{
A ggplot2 object
}
\description{
After running a projection, plot the total fishing mortality of each species
by size. The total fishing mortality is averaged over the specified time
range (a single value for the time range can be used to plot a single time
step).
}
\examples{
\donttest{
params <- suppressMessages(newMultispeciesParams(NS_species_params_gears, inter))
sim <- project(params, effort=1, t_max=20, t_save = 2, progress_bar = FALSE)
plotFMort(sim)
plotFMort(sim, highlight = c("Cod", "Haddock"))
}
}
\seealso{
\link{plotting_functions}, \code{\link[=getFMort]{getFMort()}}

Other plotting functions: 
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotPredMort}()},
\code{\link{plotSpectra}()},
\code{\link{plotYieldGear}()},
\code{\link{plotYield}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
