% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc.R
\name{covlmc_control}
\alias{covlmc_control}
\title{Control for coVLMC fitting}
\usage{
covlmc_control(pseudo_obs = 1)
}
\arguments{
\item{pseudo_obs}{number of fake observations of each state to add to the
observed ones.}
}
\value{
a list.
}
\description{
This function creates a list with parameters used to fine tune the coVLMC
fitting algorithm.
}
\details{
\code{pseudo_obs} is used to regularize the probability estimations when a
context is only observed followed by always the same state. Transition
probabilities are computed after adding \code{pseudo_obs} pseudo observations
of each of the states (including the observed one). This corresponds to a
Bayesian posterior mean estimation with a Dirichlet prior.
}
\examples{
dts <- rep(c(0, 1), 100)
dts_cov <- data.frame(y = rep(0, length(dts)))
default_model <- covlmc(dts, dts_cov)
contexts(default_model, type = "data.frame", model = "coef")$coef
control <- covlmc_control(pseudo_obs = 10)
model <- covlmc(dts, dts_cov, control = control)
contexts(model, type = "data.frame", model = "coef")$coef
}
