% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_Mix_utils.R
\name{Mix}
\alias{Mix}
\alias{print.Mix}
\alias{is.Mix}
\alias{plot.Mix}
\title{Mixtures of Univariate Distributions}
\usage{
Mix(dist, w=NULL, theta.list=NULL, name=NULL, \dots)

is.Mix(x)

\method{plot}{Mix}(
  x,
  ylim,
  xlim = NULL,
  xout = NULL,
  n = 511,
  type = NULL,
  xlab = "x",
  ylab = "f(x)",
  main = attr(obj, "name"),
  lwd = 1.4,
  log = FALSE,
  components = TRUE,
  h0 = FALSE,
  parComp = list(col = NULL, lty = 3, lwd = 1),
  parH0 = list(col = NULL, lty = 3, lwd = 1),
  ...
)

\method{print}{Mix}(x, ...)
}
\arguments{
\item{dist}{a character string giving the (abbreviated) name of the component distribution, such that the function \code{ddist} evaluates its density function and \code{rdist} generates random numbers. For example, to create a gaussian mixture, \code{dist} has to be specified as \code{norm} instead of \code{normal}, \code{gaussian} etc. for the package to find the functions \code{dnorm} and \code{rnorm}.}

\item{w}{numeric vector of length \eqn{p}, specifying the mixture weights \eqn{w[i]} of the components, \eqn{i = 1,\dots,p}. If the weights don't add up to 1, they will be scaled accordingly. Uses equal weights for all components by default.}

\item{theta.list}{named list specifying the component parameters. The names of the list elements have to match the names of the formal arguments of the functions \code{ddist} and \code{rdist} exactly. For a gaussian mixture, the list elements would have to be named \code{mean} and \code{sd}, as these are the formal arguments used by \code{rnorm} and \code{dnorm}. Alternatively, the component parameters can be supplied directly as named vectors of length \eqn{p} via \dots}

\item{name}{optional name tag of the result (used for printing and plotting).}

\item{\dots}{further arguments passed to the function plotting the mixture density.}

\item{x}{object of class \code{Mix}.}

\item{ylim}{range of y values to use; if not specified (or containing \code{NA}), the function tries to construct reasonable default values.}

\item{xlim}{range of x values to use; particularly important if \code{xout} is not specified. If both are left unspecified, the function tries to construct reasonable default values.}

\item{xout}{numeric or \code{NULL} giving the abscissae at which to draw the density.}

\item{n}{number of points to generate if \code{xout} is unspecified (for continuous distributions).}

\item{type}{character denoting the type of plot, see e.g. \code{\link[graphics]{lines}}. Defaults to \code{"l"} if the mixture distribution is continuous and to \code{"h"} otherwise.}

\item{xlab, ylab}{labels for the x and y axis with defaults.}

\item{main}{main title of plot, defaulting to the \code{\link{Mix}} name.}

\item{lwd}{line width for plotting with a non-standard default.}

\item{log}{logical; if \code{TRUE}, probabilities/densities \eqn{f} are plotted as \eqn{log(f)}. Only works if \code{components} is set to \code{FALSE}.}

\item{components}{logical indicating whether the individual mixture components should be plotted, set to \code{TRUE} by default.}

\item{h0}{logical indicating whether the line \eqn{y = 0} should be drawn.}

\item{parComp}{graphical parameters for drawing the individual components if \code{components} is set to \code{TRUE}.}

\item{parH0}{graphical parameters for drawing the line \eqn{y = 0} if \code{h0} is set to \code{TRUE}.}
}
\value{
An object of class \code{Mix} (implemented as a matrix) with the following attributes:
    \item{dim}{dimensions of the matrix.}
    \item{dimnames}{a \code{\link[base]{dimnames}} attribute for the matrix.}
    \item{name}{as entered via \code{name}.}
    \item{dist}{as entered via \code{dist}.}
    \item{discrete}{logical indicating whether the mixture distribution is discrete.}
    \item{theta.list}{as entered via \code{theta.list}.}
}
\description{
Objects of class \code{Mix} represent finite mixtures of any univariate distribution. Methods for construction, printing and plotting are provided.

\code{plot} method for \code{\link{Mix}} objects visualizing the mixture density, optionally showing the component densities.
}
\details{
Note that the \code{Mix} function will change the random number generator (RNG) state.
}
\examples{

# define 'Mix' object
normLocMix <- Mix("norm", w = c(0.3, 0.4, 0.3), mean = c(10, 13, 17), sd = c(1, 1, 1))
poisMix <- Mix("pois", w = c(0.45, 0.45, 0.1), lambda = c(1, 5, 10))

# plot 'Mix' object
plot(normLocMix)
plot(poisMix)


# define 'Mix' object
normLocMix <- Mix("norm", w = c(0.3, 0.4, 0.3), mean = c(10, 13, 17), sd = c(1, 1, 1))
poisMix <- Mix("pois", w = c(0.45, 0.45, 0.1), lambda = c(1, 5, 10))

# plot 'Mix' object
plot(normLocMix)
plot(poisMix)

}
\seealso{
\code{\link{dMix}} for the density, \code{\link{rMix}} for random numbers (and construction of an \code{rMix} object) and \code{plot.Mix} for the plot method.

\code{\link{Mix}} for the construction of \code{Mix} objects, \code{\link{dMix}} for the density of a mixture.
}
\keyword{cluster}
