% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cronbach_alpha_rough.R
\name{cronbach_alpha_rough}
\alias{cronbach_alpha_rough}
\title{Compute Rough Approximation of Cronbach's Alpha Bounds}
\usage{
cronbach_alpha_rough(scores_mat, score_max, num_try = 1000, int_only = FALSE)
}
\arguments{
\item{scores_mat}{A matrix where rows represent persons and columns represent tests (or items),
providing the performance of a person on a test. NA should be used for missing values.}

\item{score_max}{An integer indicating the largest possible score of the test.}

\item{num_try}{An integer specifying the number of random samples to generate in order to estimate the lower and upper bounds. Default is 1000.}

\item{int_only}{A logical value indicating whether to sample only integer values for missing scores. If FALSE, floating-point values between 0 and \code{score_max} are sampled. Default is FALSE.}
}
\value{
A numeric vector of length 2, where the first value is the estimated minimum Cronbach's alpha and the second value is the estimated maximum Cronbach's alpha.
}
\description{
This function computes a rough approximation of the lower and upper bounds
of Cronbach's alpha by performing random sampling or integer sampling for
missing values in the score matrix.
}
\details{
This function performs random sampling to estimate the bounds of Cronbach's alpha for a given test score matrix with missing values. It first calculates the alpha assuming all missing values are either 0 or \code{score_max}. Then, it iteratively samples either integer values or continuous values (depending on the value of \code{int_only}) for the missing scores and recalculates the Cronbach's alpha. The minimum and maximum alphas observed over all iterations are returned as the estimated bounds.
}
\seealso{
\code{\link{cronbachs_alpha}}
}
