% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{gtrack.ls}
\alias{gtrack.ls}
\title{Returns a list of track names}
\usage{
gtrack.ls(
  ...,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{...}{these arguments are of either form 'pattern' or 'attribute =
pattern'}

\item{ignore.case, perl, fixed, useBytes}{see 'grep'}
}
\value{
An array that contains the names of tracks that match the supplied
patterns.
}
\description{
Returns a list of track names in Genomic Database.
}
\details{
This function returns a list of tracks whose name or track attribute value
match a pattern (see 'grep'). If called without any arguments all tracks are
returned.

If pattern is specified without a track attribute (i.e. in the form of
'pattern') then filtering is applied to the track names. If pattern is
supplied with a track attribute (i.e. in the form of 'name = pattern') then
track attribute is matched against the pattern.

Multiple patterns are applied one after another. The resulted list of tracks
should match all the patterns.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

# get all track names
gtrack.ls()

# get track names that match the pattern "den*"
gtrack.ls("den*")

# get track names whose "created.by" attribute match the pattern
# "create_sparse"
gtrack.ls(created.by = "create_sparse")

# get track names whose names match the pattern "den*" and whose
# "created.by" attribute match the pattern "track"
gtrack.ls("den*", created.by = "track")

}
\seealso{
\code{\link{grep}}, \code{\link{gtrack.exists}},
\code{\link{gtrack.create}}, \code{\link{gtrack.rm}}
}
\keyword{~intervals}
\keyword{~ls}
