% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.saem.R
\name{miss.saem}
\alias{miss.saem}
\title{miss.saem}
\usage{
miss.saem(X.obs, y, pos_var = 1:ncol(X.obs), maxruns = 500,
  tol_em = 1e-07, nmcmc = 2, tau = 1, k1 = 50, seed = 200,
  print_iter = TRUE, var_cal = FALSE, ll_obs_cal = FALSE)
}
\arguments{
\item{X.obs}{Design matrix with missingness \eqn{N \times p}{N * p}}

\item{y}{Response vector \eqn{N \times 1}{N * 1}}

\item{pos_var}{Index of selected covariates. The default is pos_var = 1:ncol(X.obs).}

\item{maxruns}{Maximum number of iterations. The default is maxruns = 500.}

\item{tol_em}{The tolerance to stop SAEM. The default is tol_em = 1e-7.}

\item{nmcmc}{The MCMC length. The default is nmcmc = 2.}

\item{tau}{Rate \eqn{\tau}{\tau} in the step size \eqn{(k-k_{1})^{-\tau}}{(k-k1)^(-\tau)}. The default is tau = 1.}

\item{k1}{Number of first iterations \eqn{k_{1}}{k1} in the step size \eqn{(k-k_{1})^{-\tau}}{(k-k1)^(-\tau)}. The default is k1=50.}

\item{seed}{An integer as a seed set for the radom generator. The default value is 200.}

\item{print_iter}{If TRUE, miss.saem will print the estimated parameters in each iteration of SAEM.}

\item{var_cal}{If TRUE, miss.saem will calculate the variance of estimated parameters.}

\item{ll_obs_cal}{If TRUE, miss.saem will calculate the observed log-likelihood.}
}
\value{
A list with components
\item{mu}{Estimated \eqn{\mu}{\mu}.}
\item{sig2}{Estimated \eqn{\Sigma}{\Sigma}.}
\item{beta}{Estiamated \eqn{\beta}{\beta}.}
\item{time_run}{Execution time.}
\item{seqbeta}{Sequence of \eqn{\beta}{\beta} estimated in each iteration.}
\item{seqbeta_avg}{Sequence of \eqn{\beta}{\beta} with averaging in each iteration.}
\item{ll}{Observed log-likelihood.}
\item{var_obs}{Estimated variance for estimated parameters.}
\item{std_obs}{Estimated standard error for estimated parameters.}
}
\description{
This function uses algorithm SAEM to fit the logistic regression model with missing data.
}
\examples{
# Generate dataset
N <- 100  # number of subjects
p <- 3     # number of explanatory variables
mu.star <- rep(0,p)  # mean of the explanatory variables
Sigma.star <- diag(rep(1,p)) # covariance
beta.star <- c(1, 1,  0) # coefficients
beta0.star <- 0 # intercept
beta.true = c(beta0.star,beta.star)
X.complete <- matrix(rnorm(N*p), nrow=N)\%*\%chol(Sigma.star) +
              matrix(rep(mu.star,N), nrow=N, byrow = TRUE)
p1 <- 1/(1+exp(-X.complete\%*\%beta.star-beta0.star))
y <- as.numeric(runif(N)<p1)
# Generate missingness
p.miss <- 0.10
patterns <- runif(N*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA

# SAEM
list.saem = miss.saem(X.obs,y)
print(list.saem$beta)
}
