% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SingleGroup-methods.R
\docType{methods}
\name{plot-method}
\alias{plot,DiscreteClass,missing-method}
\alias{plot,MultipleGroupClass-method}
\alias{plot,SingleGroupClass,missing-method}
\alias{plot,SingleGroupClass-method}
\alias{plot-method}
\title{Plot various test implied functions from models}
\usage{
\S4method{plot}{SingleGroupClass,missing}(x, y, type = "info", npts = 50,
  theta_angle = 45, theta_lim = c(-6, 6),
  which.items = 1:ncol(x@Data$data), MI = 0, CI = 0.95, rot = list(xaxis
  = -70, yaxis = 30, zaxis = 10), facet_items = TRUE, auto.key = TRUE,
  main = NULL, drape = TRUE, colorkey = TRUE, ehist.cut = 1e-10,
  add.ylab2 = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{SingleGroupClass},
\code{MultipleGroupClass}, or \code{DiscreteClass}}

\item{y}{an arbitrary missing argument required for \code{R CMD check}}

\item{type}{type of plot to view; can be \code{'info'} to show the test
information function, \code{'infocontour'} for the test information contours,
\code{'SE'} for the test standard error function, \code{'trace'} and \code{'infotrace'}
for all item probability information or trace lines (only available when all items are dichotomous),
\code{'infoSE'} for a combined test information and standard error plot, and \code{'score'} and
\code{'scorecontour'} for the expected total score surface and contour plots.
If \code{empiricalhist = TRUE} was used in estimation then the type \code{'empiricalhist'}
also will be available to generate the empirical histogram plot}

\item{npts}{number of quadrature points to be used for plotting features.
Larger values make plots look smoother}

\item{theta_angle}{numeric values ranging from 0 to 90 used in \code{plot}.
If a vector is used then a bubble plot is created with the summed information across the angles specified
(e.g., \code{theta_angle = seq(0, 90, by=10)})}

\item{theta_lim}{lower and upper limits of the latent trait (theta) to be evaluated, and is
used in conjunction with \code{npts}}

\item{which.items}{numeric vector indicating which items to be used when plotting. Default is
to use all available items}

\item{MI}{a single number indicating how many imputations to draw to form bootstrapped confidence
intervals for the selected test statistic. If greater than 0 a plot will be drawn with a shaded
region for the interval}

\item{CI}{a number from 0 to 1 indicating the confidence interval to select when MI input is
used. Default uses the 95\% confidence (CI = .95)}

\item{rot}{allows rotation of the 3D graphics}

\item{facet_items}{logical; apply grid of plots across items? If \code{FALSE}, items will be
placed in one plot for each group}

\item{auto.key}{logical parameter passed to the \code{lattice} package}

\item{main}{argument passed to lattice. Default generated automatically}

\item{drape}{logical argument passed to lattice. Default generated automatically}

\item{colorkey}{logical argument passed to lattice. Default generated automatically}

\item{ehist.cut}{a probability value indicating a threshold for excluding cases in empirical
histogram plots. Values larger than the default will include more points in the tails of the
plot, potentially squishing the 'meat' of the plot to take up less area than visually desired}

\item{add.ylab2}{logical argument passed to lattice. Default generated automatically}

\item{...}{additional arguments to be passed to lattice}
}
\description{
Plot various test implied response functions from models estimated in the mirt package.
}
\examples{
\dontrun{
x <- mirt(Science, 1, SE=TRUE)
plot(x)
plot(x, type = 'trace')
plot(x, type = 'infotrace')
plot(x, type = 'infotrace', facet_items = FALSE)
plot(x, type = 'infoSE')

# confidence interval plots when information matrix computed
plot(x, type='score')
plot(x, type='score', MI=100)
plot(x, type='info', MI=100)
plot(x, type='SE', MI=100)

set.seed(1234)
group <- sample(c('g1','g2'), nrow(Science), TRUE)
x2 <- multipleGroup(Science, 1, group)
plot(x2)
plot(x2, type = 'trace')
plot(x2, type = 'trace', which.items = 1:2)
plot(x2, type = 'trace', which.items = 1, facet_items = FALSE) #facet by group
plot(x2, type = 'score')

x3 <- mirt(Science, 2)
plot(x3)
plot(x3, type = 'SE')

}
}

