% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{unresolved}
\alias{unresolved}
\title{Query if a mirai is Unresolved}
\usage{
unresolved(x)
}
\arguments{
\item{x}{a 'mirai' object or list of 'mirai' objects, or a 'mirai' value
stored at \verb{$data}.}
}
\value{
Logical TRUE if \code{x} is an unresolved 'mirai' or 'mirai' value or the
list contains at least one unresolved 'mirai', or FALSE otherwise.
}
\description{
Query whether a 'mirai', 'mirai' value or list of 'mirai' remains unresolved.
Unlike \code{\link[=call_mirai]{call_mirai()}}, this function does not wait for completion.
}
\details{
Suitable for use in control flow statements such as \code{while} or \code{if}.

Note: querying resolution may cause a previously unresolved 'mirai' to
resolve.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- mirai(Sys.sleep(0.1))
unresolved(m)
Sys.sleep(0.3)
unresolved(m)
\dontshow{\}) # examplesIf}
}
